ORCA/M Asm65816 2.1.0

0001 C57B                       title 'Desk Manager  GS ROM 3.0'
0002 C57B              **********************************************************************
0003 C57B              *
0004 C57B              * Desk Manager  
0005 C57B              * for the Apple II GS
0006 C57B              *
0007 C57B              * original CDA code by John Worthinton.
0008 C57B              * original NDA code by Steven Glass
0009 C57B              *
0010 C57B              * Additions and alterations by Steven Glass and
0011 C57B              * Konstantin Othmer
0012 C57B              *
0013 C57B              * System 6.0 work by Dave Lyons
0014 C57B              *
0015 C57B              **********************************************************************
0016 C57B
0017 C57B              **********************************************************************
0018 C57B              *                                                                    *
0019 C57B              *                   Copyright (C) 1985-1991                          *
0020 C57B              *                   All Rights Reserved                              *
0021 C57B              *                   Apple Computer, Inc.                             *
0022 C57B              *                                                                    *
0023 C57B              **********************************************************************
0024 C57B
0025 C57B
0026 C57B              **********************************************************************
0027 C57B              *
0028 C57B              * Change History
0029 C57B              *
0030 C57B              * Version 1.0
0031 C57B              *    John Worthington 20 May 86
0032 C57B              *
0033 C57B              * Version 2.0
0034 C57B              *    Steven Glass     Winter 86-87
0035 C57B              *
0036 C57B              * Version 3.0
0037 C57B              *    Steven Glass     Fall 87
0038 C57B              *
0039 C57B              * Change History
0040 C57B              *
0041 C57B              * 08 Oct 87    Steven Glass
0042 C57B              *
0043 C57B              * RAM patches included into rom source for first time.  Source
0044 C57B              * code was re-organized.
0045 C57B              *
0046 C57B              * 12 Oct 87    Steven Glass
0047 C57B              *
0048 C57B              * The orig ROM and ROM 2 code was built with MSB on.  The
0049 C57B              * Desk Mgr patch was built with MSB off.  We adjust MSB
0050 C57B              * below depending on what code is being assembled.
0051 C57B              *
0052 C57B              *
0053 C57B              * 23 Mar 88         Steven Glass
0054 C57B              *
0055 C57B              * There was a space in definition equs for GetNumDas.  This
0056 C57B              * caused wrong offsets on stack to be used.
0057 C57B              *
0058 C57B              * 31 Mar 88         Steven Glass
0059 C57B              *
0060 C57B              * SystemEvent now looks at the state of CDAs before sending
0061 C57B              * events on to NDAs.  This prevents CDAs from being locked out
0062 C57B              * when an NDA window is active.
0063 C57B              *
0064 C57B              * 16 Jun 88         Steven Glass
0065 C57B              *
0066 C57B              * OpenNDA call looks for zero coming back from NDA.
0067 C57B              *
0068 C57B              * 19 Jul 88         Steven Glass
0069 C57B              *
0070 C57B              * The DAHandler has been separated from the BootInit code.  It
0071 C57B              * has been re-organized and uses much less code.  Finally, a bug
0072 C57B              * where the dbr was being pulled after the processor reg (p) was
0073 C57B              * pushed is fixed.
0074 C57B              *
0075 C57B              *
0076 C57B              * 25 Jul 88         Steven Glass
0077 C57B              *
0078 C57B              * Error code from InstCDA was in wrong reg.
0079 C57B              *
0080 C57B              *
0081 C57B              * Sept-Oct 88       Konstantin Othmer
0082 C57B              *
0083 C57B              * Scrolling was added to CDA menu so more than 13 CDAs could be installed.
0084 C57B              * A run queue was added so anyone can get a call at system task time.
0085 C57B              * Removal of CDAs and NDAs added.
0086 C57B              *
0087 C57B              * 25 Oct 88         Steven Glass
0088 C57B              *
0089 C57B              * Major re-organization of files.  The purpose of the new orgainization
0090 C57B              * is to allow the patch file to share code and objecs with the ROM.
0091 C57B              *
0092 C57B              * The new orgainzation keeps the init calls in Desk.asm and
0093 C57B              * moves all other code into one of three files:
0094 C57B              *
0095 C57B              *      CDACalls.asm
0096 C57B              *      CDAMenu.asm
0097 C57B              *      NDACalls.asm
0098 C57B              *
0099 C57B              * The patch file for ROM 2.0 uses all of NDAcalls, all of CDAMenu
0100 C57B              * and small parts of CDACalls and Desk.
0101 C57B              *
0102 C57B              * A fifth file Desk.Equates.asm is also used.  It contains the 
0103 C57B              * global equates that are shared by all.
0104 C57B              *
0105 C57B              * 02 Jun 89         Steven Glass
0106 C57B              *
0107 C57B              * Zeroed variable in NDA init code.
0108 C57B              *
0109 C57B              * 15 Feb 90         Harry Yee
0110 C57B              * Fix bug in RemoveNDA. The NDA was not being removed from 
0111 C57B              * NDA list properly. Bumped version number from 3.0 to 3.1
0112 C57B              *
0113 C57B              * 26-Sep-90         Dave Lyons
0114 C57B              *
0115 C57B              * Changed macro names so it'll build.  setmode8 --> shortmx,
0116 C57B              * setmode16 --> longmx.
0117 C57B              *
0118 C57B              * 19-Feb-91         Dave Lyons
0119 C57B              *
0120 C57B              * Adding call table entries for 6.0 calls, even though this
0121 C57B              * call table doesn't actually get used for TS2 and TS3.
0122 C57B              *
0123 C57B              * 4-Mar-91          Dave Lyons
0124 C57B              *
0125 C57B              * Added SendRequest calls at the end of DeskStartUp and
0126 C57B              * DeskShutDown (used by TS2).
0127 C57B              *
0128 C57B              * 5-Aug-91          Dave Lyons
0129 C57B              *
0130 C57B              * Made DeskStartUp paranoid about the environment.  Checks
0131 C57B              * for GS/OS and for several tools being started; if things
0132 C57B              * aren't right, DeskStartUp returns, taking no action.
0133 C57B              *
0134 C57B              * 16-Sep-91         Dave Lyons
0135 C57B              *
0136 C57B              * Made DeskStartUp and DeskShutDown maintain RealDeskStatus,
0137 C57B              * for use by FixAppleMenu.
0138 C57B              *
0139 C57B              * 17-Sep-91         Dave Lyons
0140 C57B              *
0141 C57B              * Small changed to support moving calls into Tool.Setup.
0142 C57B              *
0143 C57B              * 8-Dec-91          Dave Lyons
0144 C57B              *
0145 C57B              * Conditioned out DeskShutDown fiddling with special bits
0146 C57B              * in $E100BE, since this is part of the ROM 3 kludge to make
0147 C57B              * System 4.0 run.  No point in having it lying around RAM,
0148 C57B              * and it makes old versions of SoftSwitch not run on ROM 1
0149 C57B              * (the versions that don't run on ROM 3, since they check
0150 C57B              * for $E100BE to be zero instead of checking bit 15 = GS/OS
0151 C57B              * busy).
0152 C57B              *
0153 C57B              *********************************************************
0154 C57B
0155 C57B                       eject 
0156 C57B
0157 C57B                       include 'all.macros' 
0158 C57B                       include '::sys.equs.asm' 
0159 C57B                       include 'e16.memory' 
0160 C57B
0161 C57B
0162 C57B              DAVersionNumber equ $0300 
0163 C57B
0164 C57B                       include 'Desk.Equates.asm' 
0165 C57B
0166 C57B                       title 'Desk Manager--CALL TABLE' 
0167 C57B              ****************************************************************
0168 C57B              *
0169 C57B              * DACallTable
0170 C57B              *
0171 C57B              * 
0172 C57B              *
0173 C57B              ****************************************************************
0174 C57B
0175 C57B                       EXPORT DACallTable
0176 C57B              DACallTable PROC 
0177 C57B
0178 C57B              TheBeginning  
0179 C57B 23 00 00 00           DC L:(TheEnd-TheBeginning)/4   ; num calls + 1
0180 C57F 06 C6 FE 00           DC L:DABootInit-1              ; 1
0181 C583 0D C7 FE 00           DC L:DAStartup-1               ; 2
0182 C587 28 C7 FE 00           DC L:DAShutdown-1              ; 3
0183 C58B 17 C8 FE 00           DC L:DAVersion-1               ; 4
0184 C58F 20 C8 FE 00           DC L:DAReset-1                 ; 5
0185 C593 2E C8 FE 00           DC L:DAStatus-1                ; 6
0186 C597 DE FB FE 00           DC L:oEndCall0-1               ; 7     reserved
0187 C59B DE FB FE 00           DC L:oEndCall0-1               ; 8     reserved
0188 C59F
0189 C59F 45 C8 FE 00           DC L:SaveScreen-1              ; 9
0190 C5A3 81 C8 FE 00           DC L:RestScreen-1              ; A
0191 C5A7
0192 C5A7                       EXPORT SaveAllTableEntry
0193 C5A7              SaveAllTableEntry                       ; 
0194 C5A7 35 C9 FE 00           DC L:SaveAll-1                 ; B
0195 C5AB B9 CB FE 00           DC L:RestAll-1                 ; C
0196 C5AF DE FB FE 00           DC L:oEndCall0-1               ; D
0197 C5B3 5D DA FE 00           DC L:InstallNDA-1              ; E
0198 C5B7 31 CD FE 00           DC L:instcda-1                 ; F
0199 C5BB DE FB FE 00           DC L:oEndCall0-1               ; 10
0200 C5BF CE D0 FE 00           DC L:choosecda-1               ; 11
0201 C5C3 DE FB FE 00           DC L:oEndCall0-1               ; 12
0202 C5C7 BB CE FE 00           DC L:setdastrptr-1             ; 13
0203 C5CB 17 CF FE 00           DC L:getdastrptr-1             ; 14
0204 C5CF 1B DB FE 00           DC L:OpenNDA-1                 ; 15
0205 C5D3 B6 DB FE 00           DC L:CloseNDA-1                ; 16
0206 C5D7 75 DD FE 00           DC L:SystemClick-1             ; 17
0207 C5DB AE DE FE 00           DC L:SystemEdit-1              ; 18
0208 C5DF 60 DC FE 00           DC L:SystemTask-1              ; 19
0209 C5E3 A2 D8 FE 00           DC L:SystemEvent-1             ; 1A
0210 C5E7 8F DF FE 00           DC L:GetNumNDAs-1              ; 1B
0211 C5EB DB DB FE 00           DC L:CloseNDAbyWinPtr-1        ; 1C
0212 C5EF 01 DC FE 00           DC L:CloseAllNDAs-1            ; 1D
0213 C5F3 DA DE FE 00           DC L:FixAppleMenu2-1           ; 1E
0214 C5F7 BC E0 FE 00           DC L:AddToRunQ-1               ; 1F
0215 C5FB E3 E0 FE 00           DC L:RemoveFromRunQ-1          ;20
0216 C5FF CA CD FE 00           DC L:RemoveCDA-1               ;21
0217 C603 1E E1 FE 00           DC L:RemoveNDA-1               ;22
0218 C607
0219 C607              TheEnd    
0220 C607                       ENDP 
0221 C607
0222 C607
0223 C607
0224 C607
0225 C607              ****************************************************************
0226 C607              *
0227 C607              DABootInit PROC 
0228 C607              *
0229 C607              * This is the routine that inits the desk manager
0230 C607              * at tool startup time.  This routine is only called
0231 C607              * by the Tool Locator.
0232 C607              *
0233 C607              *
0234 C607              *
0235 C607              * Inputs:
0236 C607              *                   none
0237 C607              *
0238 C607              * Outputs:
0239 C607              *                   none
0240 C607              *
0241 C607              * External Refs:
0242 C607                       import DAHandler 
0243 C607              *
0244 C607              * Entry Points:
0245 C607              *                   none
0246 C607              *
0247 C607                       longa on                       ; mode
0248 C607                       longi on
0249 C607              *
0250 C607              * Change History
0251 C607              *
0252 C607              * Original Version  John Worthington
0253 C607              *
0254 C607              * Second ROM        John Worthington
0255 C607              *
0256 C607              *   ROM DAs are re-installed if desired
0257 C607              *  
0258 C607              *
0259 C607              * Third ROM         Steven Glass
0260 C607              *
0261 C607              *   Support for NDA's (originally in RAM) added.
0262 C607              *
0263 C607              *
0264 C607              * 3 Oct 88          Konstantin Othmer
0265 C607              *
0266 C607              *  Added initialization for run queue at system task time.
0267 C607              *
0268 C607              ****************************************************************
0269 C607
0270 C607 20 76 C6              jsr   DoCDAInit
0271 C60A 20 14 C6              jsr   DoNDAInit
0272 C60D 20 7C D6              jsr   SetPanelActive
0273 C610
0274 C610 5C DF FB FE           jml   oEndCall0
0275 C614
0276 C614
0277 C614                       ENDP 
0278 C614
0279 C614
0280 C614              ****************************************************************
0281 C614              *
0282 C614              DoNDAInit PROC EXPORT
0283 C614              *
0284 C614              * This routine contains the code that inits the NDA system.
0285 C614              * It used to be part of the BootInit call but I've separated
0286 C614              * it to make it more useable with the ROM patch for version
0287 C614              * 2.0 of the ROM>
0288 C614              *
0289 C614              *
0290 C614              * Inputs:
0291 C614              *                   none
0292 C614              *
0293 C614              * Outputs:
0294 C614              *                   none
0295 C614              *
0296 C614              * External Refs:
0297 C614              *                   none
0298 C614              *
0299 C614              * Entry Points:
0300 C614              *                   none
0301 C614              *
0302 C614                       longa on                       ; mode
0303 C614                       longi on
0304 C614              *
0305 C614              * Change History
0306 C614              *
0307 C614              * 02 Jun 89         Steven Glass
0308 C614              *
0309 C614              * Zeroed the EntryCounter
0310 C614              *
0311 C614              ****************************************************************
0312 C614
0313 C614
0314 C614              ;-----------------------------------------------------------
0315 C614              ;
0316 C614              ; Init this counter.
0317 C614              ;
0318 C614                       lda   #0
0319 C614                       sta   >EntryCount
0320 C614
0321 C614
0322 C614              ;-------------------------------------------------
0323 C614              ;
0324 C614              ; Init stuff for NDAs.  Note that NDAListHandle
0325 C614              ; on direct page is not valid yet.
0326 C614              ;
0327 C614 20 9A E0              jsr   StartNDACall             ; get some direct page spack off stack
0328 C617
0329 C617
0330 C617              ;-------------------------------------------------
0331 C617              ;
0332 C617              ; Get handle for desk manager globals and put 
0333 C617              ; result on direct page.
0334 C617              ;
0335 C617
0336 C617 A9 0E 00              lda   #SizeOfDeskGlobals
0337 C61A A2 08 00              ldx   #attrNoSpec
0338 C61D 20 F1 C6              jsr   DAGetMem
0339 C620 90 03                 bcc   @1
0340 C622 82 52 19              brl   DieHorribly
0341 C625              @1        
0342 C625 85 15                 sta   NDAListHandle
0343 C627 86 17                 stx   NDAListHandle+2
0344 C629
0345 C629              ;-------------------------------------------------
0346 C629              ;
0347 C629              ; Also put copy of handle in WAP for desk mgr
0348 C629              ;
0349 C629
0350 C629 F4 00 00              PushWord #$0000                ; system
0351 C62C F4 05 00              PushWord #5                    ; tool 5
0352 C62F D4 17                 pei   NDAListHandle+2          ; handle to globals
0353 C631 D4 15                 pei   NDAListHandle
0354 C633 A2 01 0D 22           _SetWAP 
0355 C63A
0356 C63A              ;-------------------------------------------------
0357 C63A              ;
0358 C63A              ; Deref and lock handle so can init some of the
0359 C63A              ; fields in memory.
0360 C63A              ;
0361 C63A
0362 C63A 20 A1 DF              jsr   DerefNDAList
0363 C63D
0364 C63D A9 00 00              lda   #0                       ; clear the a-reg
0365 C640
0366 C640 A0 00 00              ldy   #o_NumEntries            ; no ndas are installed yet
0367 C643 97 01                 sta   [NDAListPtr],y
0368 C645
0369 C645 A0 02 00              ldy   #o_ActiveFlag            ; DeskStartup has not been called
0370 C648 97 01                 sta   [NDAListPtr],y
0371 C64A
0372 C64A A0 04 00              ldy   #o_NotAgain              ; CDA menu is not active.
0373 C64D 97 01                 sta   [NDAListPtr],y
0374 C64F
0375 C64F A0 0A 00              ldy   #o_TaskQueueHeader       ;beginning of run queue link list
0376 C652 97 01                 sta   [NDAListPtr],y           ; make it a null pointer
0377 C654 C8                    iny   
0378 C655 C8                    iny   
0379 C656 97 01                 sta   [NDAListPtr],y
0380 C658
0381 C658 48                    pha                            ; get address of tick count.
0382 C659 48                    pha   
0383 C65A F4 05 00              PushWord #5 
0384 C65D A2 03 16 22           _GetAddr 
0385 C664 A0 06 00              ldy   #o_TickAddress
0386 C667 68                    pla   
0387 C668 97 01                 sta   [NDAListPtr],y
0388 C66A C8                    iny   
0389 C66B C8                    iny   
0390 C66C 68                    pla   
0391 C66D 97 01                 sta   [NDAListPtr],y
0392 C66F
0393 C66F
0394 C66F              ;-------------------------------------------------
0395 C66F              ;
0396 C66F              ; Unlock the handle and give back the direct
0397 C66F              ; page.
0398 C66F              ;
0399 C66F
0400 C66F 20 B6 DF              jsr   UnlockNDAList
0401 C672
0402 C672 20 AE E0              jsr   EndNDACall
0403 C675
0404 C675 60                    rts   
0405 C676
0406 C676                       ENDP 
0407 C676
0408 C676
0409 C676
0410 C676
0411 C676              ****************************************************************
0412 C676              *
0413 C676              DoCDAInit PROC EXPORT
0414 C676              *
0415 C676              * This routine contains the code that inits the CDA system.
0416 C676              * It used to be part of the BootInit call but I've separated
0417 C676              * it to make it more useable with the ROM patch for version
0418 C676              * 2.0 of the ROM.
0419 C676              *
0420 C676              *
0421 C676              * Inputs:
0422 C676              *	none
0423 C676              *
0424 C676              * Outputs:
0425 C676              *	none
0426 C676              *
0427 C676              * External Refs:
0428 C676              *	none
0429 C676              *
0430 C676              * Entry Points:
0431 C676              *	none
0432 C676              *
0433 C676                       longa on                       ; mode
0434 C676                       longi on
0435 C676              *
0436 C676              ****************************************************************
0437 C676
0438 C676
0439 C676
0440 C676              ;-------------------------------------------------
0441 C676              ;
0442 C676              ; Start setting up CDA stuff.  (Do this setup 
0443 C676              ; with interrupts off.)
0444 C676              ;
0445 C676 08                    php                            ; save processor
0446 C677 78                    sei                            ; turn interrupts off
0447 C678
0448 C678 F4 12 00              PushWord #$12                  ; install the address of the cda int
0449 C67B F4 FE 00 F4           PushLong #daHandler            ; handler.
0450 C681 A2 03 10 22           _setvector 
0451 C688
0452 C688 A9 FF 00              lda   #$FF                     ; init the NumInts global.
0453 C68B 8F 67 1D E0           sta   >numints                 ; note that this trashes the next byte too!!!!!!!
0454 C68F
0455 C68F              ; The kbm data interrupt is now initialzed by Fern...
0456 C68F
0457 C68F A9 79 D4              lda   #monkeyin                ; init the KeyInput global.
0458 C692 8F 8A 1D E0           sta   >keyinput
0459 C696
0460 C696 A9 00 00              lda   #$00                     ; init the NumDAs global
0461 C699 8F 7C 1D E0           sta   >numdas
0462 C69D
0463 C69D A9 08 00              lda   #$08                     ; init the RoomLeft global
0464 C6A0 8F 88 1D E0           sta   >roomleft
0465 C6A4
0466 C6A4 48                    pha                            ; get id for the CDATabHndl
0467 C6A5 F4 00 50              pushword #$5000                ; it will have a type of $5
0468 C6A8 A2 03 20 22           _getnewid 
0469 C6AF 68                    pla   
0470 C6B0 8F 82 1D E0           sta   >idnum
0471 C6B4
0472 C6B4
0473 C6B4 A9 20 00              lda   #$0020                   ; Get memory for CDATabHndl 
0474 C6B7 A2 08 00              ldx   #attrNoSpec              ; (only $20 bytes)
0475 C6BA 20 F1 C6              jsr   DAGetMem
0476 C6BD 90 03                 bcc   GotIt
0477 C6BF 82 B5 18              brl   DieHorribly
0478 C6C2 8F 84 1D E0  GotIt    sta   >cdatabhndl
0479 C6C6 8A                    txa   
0480 C6C7 8F 86 1D E0           sta   >cdatabhndl+2
0481 C6CB
0482 C6CB F4 FE 00 F4           pushlong #pg2kludge            ; install pg2kludge as a user accessory
0483 C6D1 A2 05 0F 22           _InstallCDA 
0484 C6D8
0485 C6D8 F4 FE 00 F4           pushlong #pg2kludge            ; a kludge to install foreign kludges
0486 C6DE F4 FE 00 F4           pushlong #dastr 
0487 C6E4 A2 05 13 22           _SetDAStrPtr 
0488 C6EB
0489 C6EB 22 6E C0 FF           jsl   $FFC06E                  ; install the rom-based da's
0490 C6EF
0491 C6EF 28                    plp                            ; restore interrupt state.
0492 C6F0 60                    rts   
0493 C6F1
0494 C6F1                       ENDP 
0495 C6F1
0496 C6F1
0497 C6F1
0498 C6F1              ****************************************************************
0499 C6F1              *
0500 C6F1              DAGetMem PROC EXPORT
0501 C6F1              *
0502 C6F1              * Routine to get memory with the desk manager's
0503 C6F1              * user id.  (This used to be part of the boot init code.
0504 C6F1              * It is now separate to make building the patch easier.)
0505 C6F1              *
0506 C6F1              * Inputs:
0507 C6F1              *    a-reg  Size
0508 C6F1              *    x-reg  Attributes
0509 C6F1              *
0510 C6F1              * Outputs:
0511 C6F1              *
0512 C6F1              *    a-reg  low word of handle or error code
0513 C6F1              *    x-reg  high word of handle
0514 C6F1              *    carry  clear if no error, set if error.
0515 C6F1              *
0516 C6F1              *
0517 C6F1              * External Refs:
0518 C6F1              *	none
0519 C6F1              *
0520 C6F1              * Entry Points:
0521 C6F1              *	none
0522 C6F1              *
0523 C6F1                       longa on                       ; mode
0524 C6F1                       longi on
0525 C6F1              *
0526 C6F1              ****************************************************************
0527 C6F1
0528 C6F1
0529 C6F1 48                    pha                            ; space for result handle
0530 C6F2 48                    pha   
0531 C6F3 F4 00 00              PushWord #0                    ; high word of size
0532 C6F6 48                    pha                            ; low word of size
0533 C6F7 AF 82 1D E0           PushWord >IDNum 
0534 C6FC DA                    phx                            ; attributes
0535 C6FD 48                    pha                            ; loc info (not used)
0536 C6FE 48                    pha   
0537 C6FF A2 02 09 22           _NewHandle 
0538 C706 B0 03                 bcs   GetMemOops
0539 C708 68                    pla   
0540 C709 FA                    plx   
0541 C70A 60                    rts   
0542 C70B
0543 C70B FA           GetMemOops plx   
0544 C70C FA                    plx   
0545 C70D 60                    rts   
0546 C70E
0547 C70E
0548 C70E
0549 C70E                       ENDP 
0550 C70E
0551 C70E
0552 C70E
0553 C70E
0554 C70E
0555 C70E
0556 C70E              *********************************************************
0557 C70E              *
0558 C70E              * DAStartup
0559 C70E              *
0560 C70E              * This call activates NDA features for applications
0561 C70E              * that want them.
0562 C70E              *
0563 C70E              * Change History
0564 C70E              *
0565 C70E              * 09 Oct 87    Steven Glass
0566 C70E              *
0567 C70E              *    Original ROM and ROM 2 did not do anything
0568 C70E              *    with this call and it was always patched.
0569 C70E              *
0570 C70E              *
0571 C70E              *********************************************************
0572 C70E                       EXPORT DAStartup
0573 C70E              DAStartup PROC 
0574 C70E
0575 C70E 20 9A E0              jsr   StartNDACall
0576 C711 20 A1 DF              jsr   DerefNDAList
0577 C714
0578 C714 A0 02 00              ldy   #o_ActiveFlag
0579 C717 A9 00 80              lda   #$8000
0580 C71A 97 01                 sta   [NDAListPtr],y
0581 C71C
0582 C71C 20 DD C7              jsr   InitAll                  ; wake everyone up (a-reg is input here)
0583 C71F
0584 C71F 20 B6 DF              jsr   UnlockNDAList
0585 C722 20 AE E0              jsr   EndNDACall
0586 C725
0587 C725 5C DF FB FE           jml   oEndCall0
0588 C729
0589 C729
0590 C729                       ENDP 
0591 C729
0592 C729
0593 C729
0594 C729              *********************************************************
0595 C729              *
0596 C729              * DAShutdown
0597 C729              *
0598 C729              * This call deactivates NDA features for applications
0599 C729              * that want them.  In addition, it causes all installed
0600 C729              * DA's (New and Classic) to get a shutdown call.
0601 C729              *
0602 C729              * Change History
0603 C729              *
0604 C729              * 09 Oct 87    Steven Glass
0605 C729              *
0606 C729              *    Original ROM and ROM 2 did not do anything
0607 C729              *    with this call and it was always patched.
0608 C729              *
0609 C729              * XX Oct 88         Steven Glass
0610 C729              *
0611 C729              * Horrible hack added.
0612 C729              *
0613 C729              * 07 Dec 88         Steven Glass
0614 C729              *
0615 C729              * Added setting of PatchLoadedBit.
0616 C729              *********************************************************
0617 C729              DAShutdown PROC EXPORT
0618 C729
0619 C729              ;-----------------------------------------------------------
0620 C729              ;
0621 C729              ; This is part of our horrible hack to keep GS/OS from
0622 C729              ; system disk 4.0 running under the 3.0 rom.
0623 C729              ;
0624 C729              ; If P8 is active now, we must clear the bit that
0625 C729              ; tells YouveGotToBeKidding not to patch the os.
0626 C729              ;
0627 C729              ; Also always set the patch loaded bit so that 
0628 C729              ; the tool locator can know when the patch has
0629 C729              ; finished loading
0630 C729              ;
0631 C729
0632 C729 48                    pha                            ; save the a-reg
0633 C72A
0634 C72A AF BE 00 E1           lda   >OS_Flag                 ; set the patch loaded bit: there is no way we can
0635 C72E 09 04 00              ora   #PatchLoadedBit          ; get here without loading the patch first.
0636 C731 8F BE 00 E1           sta   >OS_Flag
0637 C735
0638 C735 AF BC 00 E1           lda   >OS_Kind                 ; is P8 active now
0639 C739 29 FF 00              and   #$00FF
0640 C73C D0 14                 bne   NeverMind                ; no, so skip the rest
0641 C73E
0642 C73E AF BE 00 E1           lda   >OS_Flag                 ; look at the OS_flag. If bit 1 is set
0643 C742 29 02 00              and   #BadOSBit                ; then this is a situation that we do our silly stuff
0644 C745 F0 0B                 beq   NeverMind                ; If not, we skip the rest
0645 C747
0646 C747 AF BE 00 E1           lda   >OS_Flag                 ; Clear bit 0 so that the patch routine will try again.
0647 C74B 29 FE FF              and   #$FFFF-SpecialBit
0648 C74E 8F BE 00 E1           sta   >OS_Flag
0649 C752
0650 C752
0651 C752              NeverMind  
0652 C752 68                    pla                            ; restore the a-reg
0653 C753
0654 C753
0655 C753              ;-------------------------------------------------
0656 C753              ;
0657 C753              ; First shutdown all the NDAs and clear the
0658 C753              ; active flag in the global data structure.
0659 C753              ;
0660 C753
0661 C753 5A                    phy                            ; save WAP value on stack
0662 C754 48                    pha   
0663 C755
0664 C755 A2 05 1D 22           _CloseAllNDAs                  ; close all open NDAs
0665 C75C
0666 C75C 68                    pla   
0667 C75D 7A                    ply   
0668 C75E 20 9A E0              jsr   StartNDACall
0669 C761 20 A1 DF              jsr   DerefNDAList
0670 C764
0671 C764 A0 02 00              ldy   #o_ActiveFlag
0672 C767 A9 00 00              lda   #$0000
0673 C76A 97 01                 sta   [NDAListPtr],y
0674 C76C 20 DD C7              jsr   InitAll                  ; shut all NDAs down (a-reg is intput here)
0675 C76F
0676 C76F 20 B6 DF              jsr   UnlockNDAList
0677 C772
0678 C772
0679 C772              ;-----------------------------------------------------
0680 C772              ;
0681 C772              ; Now comes the hard work of sending the shutdown
0682 C772              ; message to the classic desk accessories.
0683 C772              ;
0684 C772              ;
0685 C772              ; Look at the count of das.
0686 C772              ; Strange Notes:
0687 C772              ;
0688 C772              ;    This number is not what it seems.  The control panel
0689 C772              ;    is not counted in this value nor is the handle to the
0690 C772              ;    control panel in the list.
0691 C772              ;
0692 C772              ;    If the value is 1, the only CDA installed is the Alt
0693 C772              ;    display mode.
0694 C772              ;
0695 C772              ;    So the number here is the number of CDAs other than the
0696 C772              ;    control panel that have been installed.
0697 C772
0698 C772 AF 7C 1D E0           lda   >numdas                  ; Get the number and dec by one
0699 C776 3A                    dec   a                        ;
0700 C777 30 48                 bmi   SkipThis                 ; If neg, something weird has
0701 C779              ;                                       ; happened and we quit
0702 C779              ;                                       ; (its Weird cause Alt disp mode
0703 C779              ;                                       ; is supposed to be there.)
0704 C779
0705 C779
0706 C779 48                    pha                            ; put this on stack as counter
0707 C77A
0708 C77A AF 84 1D E0           lda   >cdatabhndl              ; get the handle to the list
0709 C77E 85 15                 sta   NDAListHandle
0710 C780 AF 86 1D E0           lda   >cdatabhndl+2
0711 C784 85 17                 sta   NDAListHandle+2
0712 C786
0713 C786 20 A1 DF              jsr   DerefNDAList
0714 C789
0715 C789 A5 01                 lda   NDAListPtr
0716 C78B 85 09                 sta   PtrToThisOne
0717 C78D A5 03                 lda   NDAListPtr+2
0718 C78F 85 0B                 sta   PtrToThisOne+2
0719 C791
0720 C791              Loop                                    ; ; shut them down one at a time.
0721 C791 A7 09                 lda   [PtrToThisOne]           ; get the handle to the CDA out of table
0722 C793 85 0D                 sta   NDAHandle
0723 C795 A0 02 00              ldy   #2
0724 C798 B7 09                 lda   [PtrToThisOne],y
0725 C79A 85 0F                 sta   NDAHandle+2
0726 C79C 20 C1 DF              jsr   DerefNDAHandle
0727 C79F
0728 C79F A5 12                 lda   NDAPtr+1                 ; look at the address of the da
0729 C7A1 C9 00 F0              cmp   #$F000                   ; is it in ROM?
0730 C7A4 B0 04                 bcs   SkipThisCall             ; don't make call to rom DA's
0731 C7A6
0732 C7A6 22 C8 C7 FE           jsl   CallCDA                  ; call this thing
0733 C7AA
0734 C7AA              SkipThisCall                            ; 
0735 C7AA A5 09                 lda   PtrToThisOne
0736 C7AC 18                    clc   
0737 C7AD 69 04 00              adc   #4
0738 C7B0 85 09                 sta   PtrToThisOne
0739 C7B2 90 02                 bcc   NoBump2
0740 C7B4 E6 0B                 inc   PtrToThisOne+2
0741 C7B6              NoBump2    
0742 C7B6
0743 C7B6 A3 01                 lda   1,s                      ; dec the counter
0744 C7B8 3A                    dec   a
0745 C7B9 83 01                 sta   1,s
0746 C7BB 10 D4                 bpl   Loop                     ; if still positive, there is more
0747 C7BD
0748 C7BD 68                    pla                            ; pull counter off stack
0749 C7BE
0750 C7BE 20 B6 DF              jsr   UnlockNDAList            ; unlock the CDA list
0751 C7C1
0752 C7C1
0753 C7C1 20 AE E0     SkipThis jsr   EndNDACall
0754 C7C4
0755 C7C4 5C DF FB FE           jml   oEndCall0
0756 C7C8
0757 C7C8
0758 C7C8              ;-----------------------------------------------------
0759 C7C8              ;
0760 C7C8              ; local routine to actually call the CDA
0761 C7C8              ;
0762 C7C8              CallCDA                                 ; 
0763 C7C8 A7 11                 lda   [NDAPtr]                 ; get length byte
0764 C7CA 29 FF 00              and   #$00FF                   ; mask off first char
0765 C7CD 18                    clc                            ; add 1 for length byte and 4
0766 C7CE 69 06 00              adc   #6                       ; for main entry point to find
0767 C7D1              ;                                       ; and 1 for high 2 bytes
0768 C7D1 A8                    tay                            ; shutdown entry point
0769 C7D2
0770 C7D2 B7 11                 lda   [NDAPtr],y
0771 C7D4 48                    pha   
0772 C7D5 88                    dey   
0773 C7D6 B7 11                 lda   [NDAPtr],y
0774 C7D8 8B                    phb   
0775 C7D9 3A                    dec   a
0776 C7DA 83 01                 sta   1,s
0777 C7DC 6B                    rtl   
0778 C7DD
0779 C7DD
0780 C7DD                       ENDP 
0781 C7DD
0782 C7DD
0783 C7DD
0784 C7DD              ****************************************************************
0785 C7DD              *
0786 C7DD              * InitAll
0787 C7DD              *
0788 C7DD              * This routine sends the word passed in the a register to
0789 C7DD              * each of the NDAs in the list.
0790 C7DD              *
0791 C7DD              ****************************************************************
0792 C7DD                       EXPORT InitAll
0793 C7DD              InitAll  PROC 
0794 C7DD                       DefineStack 
0795 C7DD              Counter  word 
0796 C7DD              MsgToSend word 
0797 C7DD
0798 C7DD 48                    pha                            ; put msg to send on stack
0799 C7DE F4 00 00              PushWord #0                    ; init counter on stack
0800 C7E1
0801 C7E1 A5 01                 lda   NDAListPtr
0802 C7E3 18                    clc   
0803 C7E4 69 0E 00              adc   #SizeofDeskGlobals
0804 C7E7 85 09                 sta   PtrToThisOne
0805 C7E9 A5 03                 lda   NDAListPtr+2
0806 C7EB 90 01                 bcc   NoCarry
0807 C7ED 1A                    inc   a
0808 C7EE 85 0B        NoCarry  sta   PtrToThisOne+2
0809 C7F0
0810 C7F0
0811 C7F0              InitLoop                                ; ; keep initing until done
0812 C7F0 A3 01                 lda   Counter,s
0813 C7F2 C7 01                 cmp   [NDAListPtr]
0814 C7F4 B0 1F                 bcs   AllDone
0815 C7F6
0816 C7F6              ; Stack Equates are off by 2 after this call.
0817 C7F6 20 22 E0              jsr   SetResID
0818 C7F9
0819 C7F9 A3 05                 lda   MsgToSend+2,s
0820 C7FB 22 88 E0 FE           jsl   SendInit
0821 C7FF
0822 C7FF 20 4D E0              jsr   RepResID
0823 C802              ; Stack equates are now correct.
0824 C802
0825 C802 A3 01                 lda   Counter,s                ; bump the counter
0826 C804 1A                    inc   a
0827 C805 83 01                 sta   Counter,s
0828 C807
0829 C807 A5 09                 lda   PtrToThisOne             ; bump the PtrToThisOne
0830 C809 18                    clc   
0831 C80A 69 24 00              adc   #NDARecSize
0832 C80D 85 09                 sta   PtrToThisOne
0833 C80F 90 02                 bcc   NoCarry2
0834 C811 E6 0B                 inc   PtrToThisOne+2
0835 C813 80 DB        NoCarry2 bra   InitLoop                 ; do it again
0836 C815
0837 C815
0838 C815              AllDone                                 ; 
0839 C815 68                    pla                            	; clear the stack
0840 C816 68                    pla   
0841 C817 60                    rts   
0842 C818
0843 C818                       ENDP 
0844 C818
0845 C818
0846 C818
0847 C818              *********************************************************
0848 C818              *
0849 C818              *********************************************************
0850 C818                       EXPORT DAVersion
0851 C818              DAVersion PROC 
0852 C818
0853 C818              ret1     equ 1 
0854 C818              ret2     equ ret1+3 
0855 C818              result   equ ret2+3 
0856 C818
0857 C818 A9 00 03              lda   #DAVersionNumber
0858 C81B 83 07                 sta   result,s
0859 C81D
0860 C81D 5C DF FB FE           jml   oEndCall0
0861 C821
0862 C821                       ENDP 
0863 C821
0864 C821
0865 C821              *********************************************************
0866 C821              *
0867 C821              *********************************************************
0868 C821                       EXPORT DAReset
0869 C821              DAReset  PROC 
0870 C821
0871 C821 E2 30                 shortmx 
0872 C823 A9 FF                 lda   #$FF
0873 C825 8F 67 1D E0           sta   >numints
0874 C829 C2 30                 longmx 
0875 C82B 5C DF FB FE           jml   oEndCall0
0876 C82F
0877 C82F                       ENDP 
0878 C82F
0879 C82F
0880 C82F              *********************************************************
0881 C82F              *
0882 C82F              * DAStatus
0883 C82F              *
0884 C82F              * This routine returns whether or not the DestStartup
0885 C82F              * call has been made.  
0886 C82F              *
0887 C82F              * Change History
0888 C82F              *
0889 C82F              * 09 Oct 87        Steven Glass
0890 C82F              *
0891 C82F              *    Original ROM and ROM 2 always returned true but 
0892 C82F              *    were also always patched out.
0893 C82F              *
0894 C82F              *
0895 C82F              *
0896 C82F              *********************************************************
0897 C82F                       EXPORT DAStatus
0898 C82F              DAStatus PROC 
0899 C82F              Result   equ FirstInput 
0900 C82F
0901 C82F 20 9A E0              jsr   StartNDACall
0902 C832 20 A1 DF              jsr   DerefNDAList
0903 C835
0904 C835 A0 02 00              ldy   #o_ActiveFlag
0905 C838 B7 01                 lda   [NDAListPtr],y
0906 C83A 85 21                 sta   Result
0907 C83C
0908 C83C 20 B6 DF              jsr   UnlockNDAList
0909 C83F 20 AE E0              jsr   EndNDACall
0910 C842
0911 C842 5C DF FB FE           jml   oEndCall0
0912 C846
0913 C846                       ENDP 
0914 C846
0915 C846                       END   
